/*
 * main.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "util/Exception.h"
#include "DG.h"
#include "widgets/EventListeners.h"
#include "Graphics.h"

#ifdef WIN32
#define PSEP "\\"
#include <windows.h>
#include <io.h>
#else
#include <unistd.h>
#define PSEP "/bin/"
#endif

#include <string>

/**
 * main.cc
 */

int main( int argc, char **argv )
{

        //
        // first chdir to the appropriate place (parent dir of lib/...)
        //

        string arg( argv[0] );
        
        int psep_pos = arg.rfind( PSEP );
        
        chdir( arg.substr( 0, psep_pos ).c_str() );
        
        //
        //
        //

        DG *dg = 0;

        try {
                dg = new DG( argc, argv );
        }
        catch ( Exception exp ) {
                cout << " :: Exception in main constructing DG: " << exp << endl;
                exit( 1 );
        }

        int val = dg->startGameLoop( argc, argv );
        
        delete dg;

        return val;
}
