/*
 * server/Player.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "Player.h"
#include "Item.h"
#include "LightSource.h"
#include "Sound.h"

#include <iostream>
#include <cstdio>

Player::Player( const char * name, const char * alias )
        : Character( name, alias ),
          _peer( 0 )
{
        _light = LightSource::getLight( 0, 0, 64,
                                        255, 255, 255,
                                        200, 
                                        0, -1 );
        setModelName( "pknight/tris" );
        setSkinName( "models/pknight/knight" );
        
        setWeaponModelName( "pknight/axe" );
        setWeaponSkinName( "models/pknight/axe" );

        _viewFrame = 0;
        _viewFrameUp = true;
}

Player::~Player() {
}

bool Player::think( unsigned int tick ) {
        return Character::think( tick );
}
