/*
 * server/Player.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Player_h__
#define __Player_h__

#include "Character.h"

class Player : public Character {
        class Peer * _peer;
public:

        Player( const char * name, const char * alias );
        virtual ~Player();
        
        void handleInput( const char * data, int len );
        void interpret( const char * buf );
        bool send( const char * msg );
        
        inline void setPeer( class Peer * peer ) { _peer = peer; }
        inline class Peer * getPeer() const { return _peer; }
        bool think( unsigned int tick );

};

enum PlayerCommandType {
        CMD_MOVE,
        CMD_DROP_ITEM,
        CMD_EQUIP_ITEM,
        CMD_UNEQUIP_ITEM
};

#endif

