/*
 * server/Projectile.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/**
 * A projectile is an entity whos lifespan is only the duration of its flight.
 * A projectile's main purpose in life is to fly through the air and collide with something
 */

#ifndef __Projectile_h__
#define __Projectile_h__

#include "Entity.h"

class Projectile : public Entity {
public:
        
        enum Type {
                NONE,
                FIREBALL
        };
        
        Type _type;
        Projectile( Type type = NONE, class Entity * owner = 0 );
        ~Projectile();
        bool collideWith( class Entity * other, const float * normal );
        bool think( unsigned int tick );
private:
        enum Mode {
                P_FLYING,
                P_EXPLODING
        };

        Mode _mode;
        int _counter;
        class Sound * _flight_sound;

};

#endif
