/*
 * server/ProtoEntity.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */


#include "ProtoEntity.h"
#include <iostream>
#include <string>

ProtoEntity::ProtoEntity( class istream & is ) {
        
        ok = false;
        
        char buf[1024];
        int line_num = 0;
        
        const int NUM_LINES = 7;
        
        while ( is.getline( buf, 1024 ) ) {
                
                if ( *buf == '#' || *buf == 0 )
                        continue;
                
                char * token = 0;
                int token_num = 0;
                
                switch ( line_num ) {
                        
                case 0: vnum = atoi( buf ); break;
                case 1: strncpy( name, buf, MAX_NAME ); break;
                case 2: strncpy( alias, buf, MAX_ALIAS ); break;
                case 3: strncpy( skin, buf, MAX_GFX_HINT ); break;
                case 4: strncpy( model, buf, MAX_GFX_HINT ); break;
                case 5: strncpy( icon, buf, MAX_GFX_HINT ); break;
                case 6:
                        token = strtok( buf, " " );
                        token_num = 0;
                        
                        while ( token ) {

                                switch ( token_num ) {

                                case 0: weight   = atoi( token ); break;
                                case 1: radius   = atoi( token ); break;
                                case 2: height   = atoi( token ); break;
                                case 3: model_trans[0]   = atoi( token ); break;
                                case 4: model_trans[1]   = atoi( token ); break;
                                case 5: model_trans[2]   = atoi( token ); break;
                                default: cout << " too many tokens" << endl; break;
                                }
                                ++token_num;
                                token = strtok( 0, " " );
                        }
                        break;
                }
                

                if ( ++line_num == NUM_LINES )
                        break;
        }

        
        if ( line_num != NUM_LINES ) {
                // nothing to read
                if ( line_num != 0 ) {
                        cout << " error reading, got " << ( line_num - 1 ) << " lines" << endl;
                        return;
                }
        }

        if ( ! strcmp( model, "." ) )
                strcpy( model, skin );
        if ( ! strcmp( icon, "." ) )
                strcpy( icon, skin );

        strcpy( gfx_hint, skin );
        
        ok = true;
}
