/*
 * server/SectorSpecial.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "SectorSpecial.h"
#include "../util/Persist.h"

#include <iostream>

SectorSpecial::SectorSpecial( istream & is ) {
        
        sect = 0;
        
        cur_travel = 0;
        iterations = 0;
        wait_tick  = 0;
        
        flags  = Persist::readShort( is );
        travel = Persist::readShort( is );
        damage = Persist::readShort( is );
        sound  = Persist::readShort( is );

        speed      = is.get();
        delay      = is.get();
        tag        = is.get();
        iterations = is.get();

        if ( flags & START_EXTENDED )
                flags &= ~IS_EXTENDING;
        else
                flags |= IS_EXTENDING;

}

void SectorSpecial::writeSectorSpecial( ostream & os ) {
        Persist::writeShort( os, flags );
        Persist::writeShort( os, travel );
        Persist::writeShort( os, damage );
        Persist::writeShort( os, sound );

        os.put( speed );
        os.put( delay );
        os.put( tag );
        os.put( iterations );

}

