/*
 * server/Server.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Server_h__
#define __Server_h__

#ifdef WIN32
#include <windows.h>
#endif

#include <SDL/SDL.h>
#include <SDL/SDL_net.h>
#include <SDL/SDL_thread.h>

#include "../util/Vector.h"


class Server {
        static const size_t MAX_CLIENTS = 16;

	IPaddress _serverIP;

        TCPsocket        _servsock;
        SDLNet_SocketSet _socketset;
        SDL_Thread *     _thread;

        bool handleNewConnection();
        bool handlePeer( class Peer * peer );
        class Vector< class Peer *> _peers;

        class World * _world;
        
public:
        Server( int port );
        ~Server();

        void run( bool spawnthread );
};

#endif
