/*
 * server/illuminate.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "Zone.h"

#include <SDL/SDL.h>

#include <math.h>
#include <iostream>
#include <fstream>
#include <cstdio>

int texel_size = 12;
int sample_size = 2;
float scatter_threshold = 1;
float scatter_minval = 0.5;

char output_filename[1024] = {0};
char * filename = 0;
char * exename = 0;

void show_usage() {
        cout << " :: Usage: " << exename << " [options] <filename>" << endl
             << " ::         -t <texelsize>" << endl
             << " ::         -s <samplesize>" << endl
             << " ::         -S <scatter>" << endl
             << " ::         -i <scatter minval>" << endl
             << " ::         -o <outputfile>" << endl;
}

int main( int argc, char ** argv ) {
        
        exename = argv[0];
        
        if ( argc < 2 ) {
                show_usage();
                return 1;
        }
        
        int argi = 1;
        
        for ( ; argi < argc; ++argi ) {
                if ( ! strcmp( argv[argi], "-t" ) ) {
                        if ( ++argi >= argc ) {
                                cout << " :: -t requires an argument." << endl;
                                return 1;
                        }
                        texel_size = atoi( argv[argi] );
                        continue;
                }
                if ( ! strcmp( argv[argi], "-s" ) ) {
                        if ( ++argi >= argc ) {
                                cout << " :: -s requires an argument." << endl;
                                return 1;
                        }
                        sample_size = atoi( argv[argi] );
                        continue;
                }
                if ( ! strcmp( argv[argi], "-S" ) ) {
                        if ( ++argi >= argc ) {
                                cout << " :: -S requires an argument." << endl;
                                return 1;
                        }
                        scatter_threshold = atof( argv[argi] );
                        continue;
                }
                if ( ! strcmp( argv[argi], "-i" ) ) {
                        if ( ++argi >= argc ) {
                                cout << " :: -i requires an argument." << endl;
                                return 1;
                        }
                        scatter_minval = atof( argv[argi] );
                        continue;
                }
                if ( ! strcmp( argv[argi], "-o" ) ) {
                        if ( ++argi >= argc ) {
                                cout << " :: -o requires an argument." << endl;
                                return 1;
                        }
                        strcpy( output_filename, argv[argi] );
                        continue;
                }
                
                if ( * argv[argi] == '-' ) {
                        cout << " :: unknown option: " << argv[ argi ] << endl;
                        show_usage();
                        return 1;
                }

                break;
        }

        filename = argv[ argi ];
        ifstream ifs( filename );
        
        if ( !ifs ) {
                cout << " :: NO zone file: " << filename << endl;
                return 1;
        }

        class Zone * zone = new Zone( "", "" );
        zone->loadEntity( ifs );
        ifs.close();
             
        if ( ! zone->illuminate( sample_size, texel_size, 
                                 scatter_threshold, scatter_minval ) ) {
                cout << " :: unable to illuminate" << endl;
                return 1;
        }
        
        if ( ! * output_filename )
                strcpy( output_filename, filename );
                //                sprintf( output_filename, "%s.out", filename );
        
        ofstream ofs( output_filename );
        
        int wb = zone->writeZone( ofs );

        ofs.close();
        
        if ( ! wb ) {
                cout << " :: unable to write zone" << endl;
        }

        return 0;
}
