/*
 * util/TextureManager.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "GFX.h"
#include "TextureManager.h"

#include <GL/glu.h>

#include <iostream>

class TextureObject * TextureManager::_textures[ TextureManager::MAX_TEXTURES ];
int TextureManager::_num_textures = 0;

GLuint TextureManager::_dummy_tex = 0;
const string TextureManager::GFX_DIR = "gfx/";

void TextureManager::init() {

        cout << " :: Initializing TextureManager" << endl;
        
        glGenTextures( 1, & _dummy_tex );
        
        if ( _dummy_tex == 0 ) {
                cout << " !!! error creating dummy texture !!! " << endl;
        }
        else {
                const static unsigned char dummy_texture_pixels[8] = { 0xff, 0xff, 0xff };
                
                glPixelStorei( GL_UNPACK_ROW_LENGTH, 1 );
                glBindTexture( GL_TEXTURE_2D, _dummy_tex );
                
                glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
                glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
                
                glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
                glTexParameterf( GL_TEXTURE_2D,
                                 GL_TEXTURE_MIN_FILTER,
                                 GL_NEAREST );
                        
                glTexEnvi( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE );
                
                glTexImage2D( GL_TEXTURE_2D,
                              0,
                              3,
                              1,
                              1,
                              0,
                              GL_RGB,
                              GL_UNSIGNED_BYTE,
                              dummy_texture_pixels );
                
        }

        // pre-create null texture
       
        if ( ! getTexture( "textures/null", GL_RGB ) ) {
                cout << " :: Error pre-creating null texture object." << endl;
        }
}


class TextureObject * TextureManager::getTexture( const char * name , GLenum type ) {

        class TextureObject * to = findTexture( name );

        if ( to == 0 ) {
                //                cout << _num_textures << " unable to find texture for " << name << endl;
                
                if ( _num_textures >= MAX_TEXTURES ) {
                        cout << " :: WARNING: out of texture allocation slots." << endl;
                        return _textures[0];
                }
                                
                to = new TextureObject( name, type );
                
                if ( to->_index == 0 ) {
                        to->_index = _dummy_tex;
                        to->_ok = true;
                }
                
                _textures[ _num_textures++ ] = to;
        }
        return to;

}


void TextureManager::purge() {
        
        while ( _num_textures ) {
                _textures[ --_num_textures ] = 0;
        }
}
