#include <iostream>
#include <iomanip>

#include "md2_file.h"
#include "md2_model.h"

int main( int argc, char ** argv ) {
        if ( argc < 2 ) {
                cout << " arg" << endl;
                exit( 1 );
        }

        ifstream ifs( argv[1] );
        
        if ( ! ifs ) {
                cout << " no file" << endl;
                exit( 1 );
        }
        
        md2_file::model_t md;
        ifs.read( &md, sizeof( md2_file::model_t ) );
        cout << md;
        
        ifs.close();

        md2_model_t model( argv[1] );
        
        for ( int i = 0; i < model.numFrames; ++i ) {
                cout << setw(3) << i << " " << model.frames[i].name << endl;
        }
        //        cout << &model << endl;

        return 0;
}
