/*
 * widgets/LabelWidget.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __LabelWidget_h__
#define __LabelWidget_h__

#include "Widget.h"

class LabelWidget : public Widget {

        char * _text;
        bool _paintBase;

public:
        void paint();
        LabelWidget( int w, int h, const char *text = 0 );
        LabelWidget();
        ~LabelWidget();

        void setText( const char *text );
        inline const char * getText() const { return _text; }

        inline void setPaintBase( bool flag ) {
                _paintBase = flag;
                //                Widget::setNeedsToPaintBase( flag );
        }
};

#endif

