/*
 * widgets/SliderWidget.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __SliderWidget_h__
#define __SliderWidget_h__

#include "Widget.h"
#include "ButtonWidget.h"

enum SliderType {
        SLIDER_VERTICAL,
        SLIDER_HORIZONTAL
};

class SliderKnobWidget : public ButtonWidget {
        GLuint _displayListIndex;
        class SliderWidget *_slider;
        /** coordinate along the slider's major axis, relative to the origin of the knob */
        int _grabbedAtRelative;
public:
        SliderKnobWidget( int w, int h, class SliderWidget *_slider );
        void paint();
        bool mousePressed( SDL_MouseButtonEvent * evt );
        bool mouseReleased( SDL_MouseButtonEvent * evt );
        bool mouseMoved( SDL_MouseMotionEvent * evt );
};

class SliderWidget : public Widget {

        friend class SliderKnobWidget;

        enum SliderType _type;

        GLuint _railListIndex;
        
        int _maxTick;
        int _tickPixelInterval;
        int _majorTickInterval;
        int _curTick;
        int _railMargin;
        int _railPos[2][2];
        int _railLen;
        
        class SliderKnobWidget *_knobWidget;
public:

        SliderWidget( int w, int h, 
                      enum SliderType type,
                      int maxTick, 
                      int majorInterval, 
                      int startTick );

        void paint();

        int attemptSlide( int amount );
        bool mousePressed( SDL_MouseButtonEvent * evt );

};

#endif
