/*
 * Graphics.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Graphics_h__
#define __Graphics_h__

#include <SDL/SDL.h>
#include <iostream>

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>

#include "util/Exception.h"

class Graphics {
        bool _loopStarted;
        bool _loopRunning;

        //        class Widget *_widgetPane;
        class WidgetManager * _wm;

        //        class Widget *_consoleWidget;

        class DG * _dg;
        
        GLuint CUBE_DISPLAY_LIST_IDX;
        GLuint PTR_DEFAULT_DISPLAY_LIST_IDX;
        
        static const int _preferredBpp[];

        struct VideoMode {
        private:
                inline void init( int w, int h, int bpp ) {
                        _flags  = SDL_OPENGL;
                        _width = w;
                        _height = h;
                        _bpp = bpp;
                }
        public:
                Uint32 _flags;
                int    _width;
                int    _height;
                int    _bpp;

                VideoMode() {
                        init( 640, 480, 16 );
                }

                VideoMode( int w, int h, int bpp ) {
                        init( w, h, bpp );
                }
                
                friend ostream &operator<<( ostream &os, Graphics::VideoMode& vm ) {
                        os << " [" << vm._width << "x" << vm._height << " @ " << vm._bpp << " bpp]";
                        return os;
                }

        };
        
        VideoMode _videoMode;

        bool setVideoMode();
        void initGLState();
        void initGLDisplayLists();
        
        bool _use3dfx;
        
        GLubyte ** _screenshotCache;
        int _screenshotCacheSize;
        int _screenshotCacheUsed;
        int _screenshotLastIndex;
        
        bool _grab;
        bool _fullscreen;
public:
        
        static GLuint FONT_DISPLAY_LIST_IDX;
        
        inline class WidgetManager * getWidgetManager() const { return _wm; }
        
        void updateGraphics();
        bool initGraphics( int argc, char **argv );
        void setLoopRunning( bool running );
        Graphics( class DG *dg, int argc, char **argv) throw (class GraphicsException); 
        ~Graphics();
        
        int getVideoModeHeight() const { return _videoMode._height; }
        int getVideoModeWidth() const { return _videoMode._width; }
        
        inline int getScreenshotCacheSize() const { return _screenshotCacheSize; }

        void setScreenshotCacheSize( int size );
                
        bool takeScreenshot();
        
        void setGrab( bool flag );
        inline bool getGrab() { return _grab; }
        
        void flushScreenshotCache();        
        bool dumpScreenshot( const char * filename = 0, const GLubyte * pixels = 0 );
        GLubyte * getScreenshot();
        
};

class GraphicsException : public Exception {
public:
        GraphicsException( const char *message );
};

#endif
