/*
 * client/ClientSound.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __ClientSound_h__
#define __ClientSound_h__

/**
 * the client-side representation of a sound
 */

class ClientSound {
        static const int MAX_SOUNDS = 64;
        
        static class ClientSound _csounds[ MAX_SOUNDS ];
        
        static int num_used;
        mutable bool reserved;
        
public:
        
        mutable int volume;
        mutable int loops;
        mutable int channel;
        mutable int idnum;
        mutable bool ok;

        ClientSound();
        
        /**
         * locate a sound by idnum 
         */

        static const class ClientSound * findSound( int idnum );
        
        /**
         * locate or add a sound by idnum
         * set volume and loops if adding, otherwise these parameters are ignored
         */
        static const class ClientSound * addSound( int idnum, int volume, int loops );

        /**
         * set the ok flag of all the sounds
         */
        static void tagSounds( bool tag );

        /**
         * purge all sounds with ok flag == false
         * non-looping sounds that are still playing are ignored, unless force is true
         */
        static void purgeSounds( bool force );
        
        /**
         * terminate and unreserve a client sound
         */
        void terminate() const;
};

#endif
