
#define __gl_stubs_cc__
#include <iostream>
#include <gl_stubs.h>

#ifdef WIN32
#include <windows.h>
#endif
  
#include <SDL/SDL.h>
#include <GL/gl.h>

#include "GraphicsState.h"

//
// setup gl extension function ptrs
//

bool setup_gl_stubs() {
        GLenum gl_error;

        if ( ( gl_error = glGetError( ) ) )
                cout << " GL_ERROR0: " << (int) gl_error << endl;
            
        glActiveTextureARB_ptr =
                (GL_ACTIVETEXTUREARB_FUNC) SDL_GL_GetProcAddress( "glActiveTextureARB" );
        glMultiTexCoord2fARB_ptr = 
                (GL_MULTITEXCOORD2FARB_FUNC) SDL_GL_GetProcAddress( "glMultiTexCoord2fARB" );
        glClientActiveTextureARB_ptr =
                (GL_CLIENTACTIVETEXTUREARB_FUNC) SDL_GL_GetProcAddress( "glClientActiveTextureARB" );

        if ( glActiveTextureARB_ptr == 0 ||
             glMultiTexCoord2fARB_ptr == 0 ||
             glClientActiveTextureARB_ptr == 0 ) {
                cout << " :: ERROR SETTING UP GL FUNC POINTERS" << endl;
                cout << " glActiveTextureARB_ptr=" 
                     << (long) glActiveTextureARB_ptr
                     << " glMultiTexCoord2fARB_ptr=" 
                     << (long) glMultiTexCoord2fARB_ptr
                     << " glClientActiveTextureARB_ptr=" 
                     << (long) glClientActiveTextureARB_ptr
                     << endl;

                cout << " :: SDL_error: " <<  SDL_GetError( ) << endl;
                
                g_state.has_multitex = false;
                
                return false;
        }

        g_state.has_multitex = true;

        return true;
            
}

#undef __gl_stubs_cc__
