/*
 * server/Item.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/* Generated by Together */

#ifndef __Item_h__
#define __Item_h__

#include "Entity.h"
#include "Character.h"

class Item : public Entity {
private:
        WornPosition _wearable;

        /**
         * @label Worn By
         * @supplierCardinality 0..1 
         */
        class Character * _wornBy;
        WornPosition      _wornPos;
        
public:

        Item( class ProtoItem * proto );
        
        Item( const char * name, const char * alias, float radius = 0, int height = 0, float angle = 0 );
        virtual ~Item();

        inline class Character * getWornBy() const { return _wornBy; }
        inline enum WornPosition getWornPos() const { return _wornPos; }
        inline enum WornPosition getWearablePos() const { return _wearable; }
        
        inline bool isWearableAt( WornPosition pos ) const { return _wearable == pos; }

        virtual bool collideWith( class Entity * other, const float * normal );
                
        /**
         * setWeight() for Item objects requires special handling because Items
         * can be equipped as well as contained
         */
        virtual void setWeight( int weight );

        //
        // inventory/equipment management for characters
        //

        friend bool Character::itemFromEquipment( class Item * item );
        friend bool Character::itemToEquipment( class Item * item, WornPosition pos );
        friend bool Character::itemFromInventory( class Item * item );

};

#endif //__Item_h__
