/*
 * server/LightSource.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __LightSource_h__
#define __LightSource_h__

class LightSource {
public:
        const static int MAX_LIGHTS = 32;
private:
        static class LightSource _lights[ MAX_LIGHTS ];
        
        static int _numReserved;

        bool _reserved;

        void init( float x, float y, float z,
                   unsigned char r,
                   unsigned char g,
                   unsigned char b,
                   unsigned short intensity );

        LightSource( float x, float y, float z,
                     unsigned char r,
                     unsigned char g,
                     unsigned char b,
                     unsigned short intensity );

public:

        LightSource();

        int _num;
        float _pos[3];
        unsigned char _rgb[3];
        unsigned short _intensity;
        int _die_tick;
        short _delta;
        
        static class LightSource * getLight( float x, float y, float z,
                                             unsigned char r,
                                             unsigned char g,
                                             unsigned char b,
                                             unsigned short intensity,
                                             short delta,
                                             int die );
        
        void release();
        
        class Sector * _sect;

        LightSource( class istream & is );
        void writeLightSource( class ostream & os ) const;

        const float * getPos() const { return _pos; }
        const unsigned char * getRGB() const { return _rgb; }
        const unsigned short getIntensity() const { return _intensity; }

        friend ostream & operator<<( ostream & os, const LightSource & light );
};

#endif





