/*
 * server/SectorSpecial.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __SectorSpecial_h__
#define __SectorSpecial_h__

class SectorSpecial {
public:
        static const short IS_DOOR         = 0x0001;
        static const short IS_LIFT         = 0x0002;

        static const short IS_EXTENDING    = 0x0010;
        //        static const short IS_RETRACTING   = 0x0012;
        
        static const short START_EXTENDED  = 0x0014;
        //        static const short START_RETRACTED = 0x0018;

        // persistant stuff
        short  flags;
        short  travel;
        short  damage;
        short  sound;

        char   speed;
        char   delay;
        char   tag;
        char   iterations;
        
        // runtime stuff
        class Sector * sect;
        short          cur_travel;
        unsigned int   wait_tick;
        
        SectorSpecial( class istream & is );
        void writeSectorSpecial( class ostream & os );
        
        bool isSet( short flag ) const { return flags & flag; }
        bool isDoor() const { return flags & IS_DOOR; }
        bool isLift() const { return flags & IS_LIFT; }
        bool isExtending() const { return flags & IS_EXTENDING; }
        bool isRetracting() const { return !isExtending(); }

        void reverseDirection() {
                flags = flags ^ IS_EXTENDING;
        }
};

#endif
