/*
 * server/SideDef.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __SideDef_h__
#define __SideDef_h__

#include <iostream>
#include "../util/Array.h"

struct SideDef {
        const static char LOWER = 0;
        const static char MAIN  = 1;
        const static char UPPER = 2;

private:
        const static char LOWER_BIT = 1 << LOWER;
        const static char MAIN_BIT  = 1 << MAIN;
        const static char UPPER_BIT = 1 << UPPER;
public:

        class Sector * sector;
        class LineDef * line;
        class Lightmap * lightmaps[3];
        const char * textures[3];
        class ClientSide * clientSide;
        
        char components;

        SideDef( class istream & is, 
                 const class Array<class LineDef *> & ls,
                 const class Array<class Sector *> & ss,
                 const class Array<const char *> & ts,
                 const class Array<class Lightmap *> & lms );
        
        void writeSide( class ostream & os );

        bool hasLower( const class SideDef *otherSide ) const { return components & LOWER_BIT; }
        bool hasUpper( const class SideDef *otherSide ) const { return components & UPPER_BIT; }
        bool hasMain(  const class SideDef *otherSide ) const { return components & MAIN_BIT; }

        bool hasWallSection( const class SideDef * otherSide, int index ) const {
                return components & ( 1 << index );
        }
        
        int getLowerHeight( const class SideDef * otherSide ) const;
        int getMainHeight( const class SideDef * otherSide ) const;
        int getUpperHeight( const class SideDef * otherSide ) const;

        int getWallSectionHeight( const class SideDef * otherSide, int index ) const;

        int getWallSectionZOrigin( const class SideDef * otherSide, int index ) const;
        
        void setSideComponents( const class SideDef * other );
};


inline int SideDef::getWallSectionHeight( const class SideDef * otherSide, int index ) const {
        if ( index == LOWER )
                return getLowerHeight( otherSide );
        else if ( index == MAIN )
                return getMainHeight( otherSide );
        else if ( index == UPPER )
                return getUpperHeight( otherSide );
        else {
                cout << " error in SideDef::getWallSectionHeight index=" << index << endl;
        }
        
        return false;
}


#endif

