/*
 * server/Sound.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Sound_h__
#define __Sound_h__

struct Sound {

        static const int SND_JUMP_SOUND      = 1;
        static const int SND_LANDING         = 2;
        static const int SND_FOOTSTEP_SMALL  = 3;
        static const int SND_FOOTSTEP_MEDIUM = 4;
        static const int SND_FOOTSTEP_BIG    = 5;
        static const int SND_PAIN_SMALL      = 6;
        static const int SND_PAIN_MEDIUM     = 7;
        static const int SND_PAIN_BIG        = 8;
        static const int SND_PAIN_FALL       = 9;
        static const int SND_GRUNT           = 10;
        static const int SND_FALLING         = 11;
        static const int SND_FIREBALL        = 12;
        static const int SND_EXPLOSION       = 13;
        static const int SND_SWORD_SLASH     = 14;
        static const int SND_AXE_SLASH       = 15;
        static const int SND_HUMAN_MALE_JUMP = 16;

        bool internal_delete;
        
        int idnum;

        /**
         * the server-side index of the sound to play
         */
        unsigned char index;
        /**
         * the volume of the sound to play, 0-255
         */
        unsigned char volume;
        
        /**
         * the number of loops, 0 or 1 for one iteration, -1 for constant iteration?
         */
        char loops;
        
        bool die;

        Sound() {
                init( 0, 0, 0, false );
        }

        Sound( unsigned char n, unsigned char v = 255, char c = 0, bool internal_delete = false ) {
                init( n, v, c, internal_delete );
        }

        void init( unsigned char n,
                   unsigned char v,
                   char c, bool internal_delete );
};
#endif

