/*
 * server/Zone_physics.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */


#include <cstdio>
#include <cmath>
#include <string>
#include <iomanip>
#include <fstream>

#include "Zone.h"
#include "ZoneCmd.h"
#include "World.h"
#include "Character.h"
#include "Item.h"
#include "StartPoint.h"

void Zone::loadCmds( istream & is ) {
        
        while ( is ) {
                        
                class ZoneCmd * cmd = new ZoneCmd( is );
                        
                if ( cmd->ok == false ) {
                        delete cmd;
                        break;
                }

                if ( cmd->type == ZoneCmd::START ) {
                        _startPoints.push_back( new StartPoint( cmd ) );
                        delete cmd;
                        continue;
                }
                                        
                _cmds.push_back( cmd );
        }
      
        cout << " :: zone CMDS loaded " << _cmds.size() << endl;


}

void Zone::executeCmds( class World * world ) {
        
        class Character * last_ch = 0;
        class Item * last_item = 0;

        for ( vector<ZoneCmd *>::iterator iter = _cmds.begin();
              iter != _cmds.end(); ++iter ) {
                class ZoneCmd * cmd = *iter;
                
                class Character * ch = 0;
                class Item * item = 0;
                
                switch ( cmd->type ) {
                case ZoneCmd::CHAR:
                        if ( ( ch = world->createNewChar( cmd->vnum ) ) ) {
                                last_ch = ch;
                                ch->setPosition( cmd->pos[0],
                                                 cmd->pos[1],
                                                 cmd->pos[2] );
                                ch->setAngle( cmd->angle );
                                addEntity( ch );
                        }
                        else {
                                cout << " no such char vnum: " << cmd->vnum << endl;
                        }
                        break;
                case ZoneCmd::ITEM:
                case ZoneCmd::GIVE:
                case ZoneCmd::EQUIP:

                        if ( ( item = world->createNewItem( cmd->vnum ) ) ) {
                                last_item = item;
                                item->setPosition( (float) cmd->pos[0],
                                                   cmd->pos[1],
                                                   cmd->pos[2] );
                                item->setAngle( cmd->angle );

                                if ( cmd->type == ZoneCmd::ITEM )
                                        addEntity( item );
                                else if ( cmd->type == ZoneCmd::GIVE ||
                                          cmd->type == ZoneCmd::EQUIP ) {
                                        if ( last_ch ) {
                                                last_ch->itemToInventory( item, -1 );

                                                if ( cmd->type == ZoneCmd::EQUIP )
                                                        last_ch->equipItem( item, (WornPosition) cmd->flags[0] );
                                        }
                                }
                        }

                        else {
                                cout << " no such item: " << cmd->vnum << endl;
                        }
                        break;
                default:
                        cout << " unhandled cmd type: " << 
                                (char) cmd->type << " (" << (int) cmd->type << " )" << endl;
                        break;
                }
        }
}

void Zone::spawnCharacter( class Character * ch ) const {

        if ( _startPoints.size() <= 0 ) {
                
                cout << " :: WARNING: no spawn points, spawning at 0,0,0 [0]" << endl;

                ch->setPosition( 0, 0, 0 );
                ch->setAngle( 0 );
                return;
        }
        
        ch->setPosition( _startPoints[0]->pos );
        ch->setAngle( _startPoints[0]->angle );
        
        /*
        for ( int i = 0; i < _startPoints.size(); ++i ) {
        }
        */
}
