/*
 * util/Array.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Array_h__
#define __Array_h__

/**
 * a fixed size array
 *
 */
template<class T> class Array {
        T * values;
public:
        int length;
        
        Array()
                : values(0),
                  length(0)
        {}
        
        Array( int size ) 
                : values(0),
                  length(0)     
        {
                setSize( size );
        }
        
        inline T & operator[]( int index ) const {
                return values[index];
        }

        void setSize( int size ) {

                if ( length ) {
                        delete[] values;
                }
                
                if ( size > 0 ) {
                        length = size;
                        values = new T[ size ];
                
                        for ( int i = 0; i < size; ++i ) {
                                values[i] = (T) 0;
                        }
                }
        }

        ~Array() {
                setSize( 0 );
        }

        int findElement( T t ) const {
                for ( int i = 0; i < length; ++i ) {
                        if ( values[i] == t )
                                return i;
                }
                return -1;
        }
};

#endif

