#ifndef __md2_model_h__
#define __md2_model_h__

#include <iostream>

struct md2_frame_t {
        float * verts;
        float trans[3];
        char name[16];
};

struct md2_gl_cmd_t {
        unsigned int gl_type;
        int num_verts;
        int * verts_i;
        float * texcoords;
        md2_gl_cmd_t();
};

struct md2_model_t {
        
        bool isOk;
        char *_filename;
        int numFrames;
        int numVerts;
        int numGLCommands;

        md2_frame_t * frames;
        md2_gl_cmd_t * gl_cmds;
        
        md2_model_t( const char * dirname, const char * filename );
        ~md2_model_t();

        /**
         * bounds-checked z translation accessor
         */
        float getZTrans( int frame ) const;
        const float * getTrans( int frame ) const;
        void getBoundingInfo( int frame, int * rad, int * height, int * x, int * y, int * z ) const;
};

ostream & operator<<( ostream & os, const md2_model_t & m );

#endif
