/*
 * util/test.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "Texload.h"

#include <iostream>

#ifdef WIN32
#include <windows.h>
#endif

#include <SDL/SDL.h>

#include <GL/gl.h>
#include <GL/glu.h>

#include "BitmapFont.h"
#include "Exception.h"
#include "TextureManager.h"

int main( int argc, char **argv ) {

          
        //
        // attempt to initialize SDL
        //
        
        if( SDL_Init( SDL_INIT_VIDEO ) < 0 ) {
		fprintf(stderr,"Couldn't initialize SDL: %s\n",SDL_GetError());
		exit( 1 );
	}
        
	SDL_WM_SetCaption( "SDL GL test", "testgl" );

        //
        // setup the display attributes
        //
        
	SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16 );
        SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );
        
        if (  SDL_SetVideoMode( 640, 480, 16, SDL_OPENGL ) == 0 ) {
                cout << " :: Failed to set preferred vidmode " << endl;
                SDL_Quit();
                exit(1);
        }

        glViewport( 0, 0, 640, 480 );
	glMatrixMode( GL_PROJECTION );
	glLoadIdentity( );
        
        glShadeModel( GL_FLAT );
        
        gluOrtho2D( 0, 640, 0, 480 );
        
	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity( );

        glClearColor( 0, 0, 0, 0 );
        
        for ( int i = 1; i < argc; ++i ) {
                
                class TextureInfo ti( argv[i], GL_RGB );
                class TextureObject * to = TextureManager::getTexture( ti );

                cout << " to=" << to << endl;

                if ( to )
                        cout << *to << endl;

                glClear( GL_COLOR_BUFFER_BIT );
                glColor3f( 1, 1, 1 );
                glEnable( GL_TEXTURE_2D );
                glBindTexture( GL_TEXTURE_2D, to->getIndex() );

                float pos[] = { 
                        ( 640 - to->getSize()[0] ) / 2,
                        ( 408 - to->getSize()[1] ) / 2
                };
                
                float extent[] = { 
                        pos[0] + to->getSize()[0],
                        pos[1] + to->getSize()[1]
                };

                glBegin( GL_QUADS );
                {
                        glTexCoord2f( 0, 0 );
                        glVertex2f( pos[0], pos[1] );
                        glTexCoord2f( 1, 0 );
                        glVertex2f( extent[0], pos[1] );
                        glTexCoord2f( 1, 1 );
                        glVertex2f( extent[0], extent[1] );
                        glTexCoord2f( 0, 1 );
                        glVertex2f( pos[0], extent[1] );
                }
                glEnd();
                SDL_GL_SwapBuffers( );

                char buf[1024];
                cin.getline( buf, 1024 );
                
                /*
                try {
                        BitmapFont bf( argv[i] );
                }
                catch ( class Exception exp ) {
                        cout << exp << endl;
                }
                */
        }
        return 0;
}



