/*
 * widgets/LookAndFeel.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "LookAndFeel.h"

LookAndFeel::LookAndFeel() {
        setColor4fv( _primaryColor[0], 0.40, 0.40, 0.60 );
        setColor4fv( _primaryColor[1], 0.60, 0.60, 0.80 );
        setColor4fv( _primaryColor[2], 0.80, 0.80, 1.00 );

        setColor4fv( _secondaryColor[0], 0.40, 0.40, 0.40 );
        setColor4fv( _secondaryColor[1], 0.60, 0.60, 0.60 );
        setColor4fv( _secondaryColor[2], 0.80, 0.80, 0.80 );

        setColor4fv( _whiteColor, 1.00, 1.00, 1.00 );
        setColor4fv( _blackColor, 0.00, 0.00, 0.00 );

        setColor4fv( _highlightColor, 0.3, 0.3, 0.9 );

}

/*
 * default a = 1.0
 */

void LookAndFeel::setColor4fv( GLfloat color[4], float r, float g, float b, float a ) {
        color[0] = r;
        color[1] = g;
        color[2] = b;
        color[3] = a;
}
