/*
 * widgets/LookAndFeel.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __LookAndFeel_h__
#define __LookAndFeel_h__

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>

enum LNFColorIndex {
        COLOR_ONE = 0,
        COLOR_TWO = 1,
        COLOR_THREE = 2
};

class LookAndFeel {
        /**
         * primary 1: active window borders
         *            shadows of selected items
         *            control text
         * primary 2: 
         * primary 3: active title bar
         *            text selection
         */
        GLfloat _primaryColor[3][4];
        GLfloat _secondaryColor[3][4];
        
        GLfloat _blackColor[4];
        GLfloat _whiteColor[4];
        
        GLfloat _bgColor[4];
        GLfloat _fgColor[4];
        
        GLfloat _highlightColor[4];

        /**
         * the font for controls:  most ui components
         */
        GLuint _controlFontList;

        /**
         * the font for text areas and consoles
         */
        GLuint _textFontList;

        void setColor4fv( GLfloat color[4], float r, float g, float b, float a = 1.0 );

public:

        inline const GLfloat * getPrimaryColor( enum LNFColorIndex index ) const { return _primaryColor[index]; }
        inline const GLfloat * getSecondaryColor( enum LNFColorIndex index ) const { return _secondaryColor[index]; }

        inline const GLfloat * getFGColor() const { return _fgColor; }
        inline const GLfloat * getBGColor() const { return _bgColor; }

        inline const GLfloat * getHighlightColor() const { return _highlightColor; }
        inline const GLfloat * getWhiteColor() const { return _whiteColor; }
        inline const GLfloat * getBlackColor() const { return _blackColor; }


        /**
         * default look and feel
         */
        LookAndFeel();
};

#endif
