/*
 * widgets/ScrollpaneWidget.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __ScrollpaneWidget_h__
#define __ScrollpaneWidget_h__

#include "Widget.h"

enum ScrollPolicy {
        SCROLLBAR_NEVER,
        SCROLLBAR_ALWAYS,
        SCROLLBAR_AS_NEEDED
};

class ScrollpaneWidget : public Widget {
        enum ScrollPolicy _scrollPolicy[2];
        class Viewport *_scrollViewport;
        
        class ScrollbarWidget * _scrollbars[2];
public:

        ScrollpaneWidget( int w, int h,
                          class Widget * scrollable,
                          enum ScrollPolicy horizScrollPolicy = SCROLLBAR_AS_NEEDED,
                          enum ScrollPolicy vertScrollPolicy = SCROLLBAR_AS_NEEDED,
                          int horizScrollbarThickness = 16,
                          int vertScrollbarThickness = 16 );
        
        ~ScrollpaneWidget();

        void scrollTo( int x, int y );
        
        virtual bool keyPressed( SDL_KeyboardEvent * evt, int x, int y );

};

#endif

