/*
 * widgets/TextPaneWidget.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __TextPaneWidget_h__
#define __TextPaneWidget_h__

#include <list>

#include "Widget.h"

class TextPaneWidget : public Widget {
        list<char *> _textList;
        size_t _numSaveLines;
        char _buf[1024];
        int _bufIndex;
        int _fontWidth;
        int _numColumns;
        void appendLineRaw( const char * str );

        class Widget * _keyEventHijacker;

public:
        TextPaneWidget( int w, int h );
        ~TextPaneWidget();

        void appendText( const char * str );
        void appendLine( const char * str );

        virtual bool keyPressed( SDL_KeyboardEvent * evt, int x, int y);

        /** 
         * the hijacker/listener must be removed before or during destruction,
         * to prevent dangling pointers
         */
        void setKeyEventHijacker( class Widget * w ) {
                _keyEventHijacker = w;
        }
        
        void paint();

};
#endif
