/*
 * client/ClientSound.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include <SDL/SDL_mixer.h>

#include "ClientSound.h"
#include <iostream>

int ClientSound::num_used = 0;
class ClientSound ClientSound::_csounds[ MAX_SOUNDS ];

ClientSound::ClientSound() {
        channel = -1;
        idnum   = 0;
        ok      = false;
        reserved = false;
        loops = 0;
}

const class ClientSound * ClientSound::findSound( int idnum ) {

        for ( int i = 0; i < MAX_SOUNDS; ++i ) {

                if ( _csounds[ i ].idnum == idnum && _csounds[ i ].reserved ) {
                        return &_csounds[ i ];
                }
        }
        
        return 0;
}

const class ClientSound * ClientSound::addSound( int idnum, int volume, int loops ) {
        
        const class ClientSound * cs = findSound( idnum );
        
        if ( cs )
                return cs;
        
        if ( num_used < MAX_SOUNDS ) {
                for ( int i = 0; i < MAX_SOUNDS; ++i ) {
                        if ( ! _csounds[ i ].reserved ) {
                                ++num_used;
                                _csounds[ i ].channel  = -1;
                                _csounds[ i ].idnum    = idnum;
                                _csounds[ i ].reserved = true;
                                _csounds[ i ].volume   = volume;
                                _csounds[ i ].loops    = loops;
                                return &_csounds[ i ];
                        }
                }
        }
        
        cout << " :: out of sound slots for playing." << endl;
        
        return 0;
}

void ClientSound::tagSounds( bool tag ) {
        for ( int i = 0; i < MAX_SOUNDS; ++i ) {
                _csounds[i].ok = tag;
        }
}

void ClientSound::purgeSounds( bool force ) {
        for ( int i = 0; i < MAX_SOUNDS; ++i ) {
                if ( _csounds[i].ok == false && _csounds[i].reserved ) {
                        if ( force || 
                             _csounds[i].loops != 0 || 
                             ! Mix_Playing( _csounds[i].channel ) ) {
                                _csounds[i].terminate();
                        }
                }
        }
}

void ClientSound::terminate() const {

        Mix_HaltChannel( channel );
        channel = -1;
        idnum = 0;
        loops = 0;
        ok = false;
        reserved = false;
        --num_used;
}
