/*
 * client/GenericMenu.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __GenericMenu_h__
#define __GenericMenu_h__

#include "Client.h"

#include "GenericScreen.h"

#include "../widgets/Widget.h"
#include "../widgets/WidgetEvents.h"

class GenericMenu : public GenericScreen, public WidgetEventListener {
        class ButtonWidget ** _buttons;
        class LabelWidget  *  _label;
        Client::State        *  _states;
        class Widget       *  _panel;

        int _preferredPos[2];
        int _numButtons;
        
        class ButtonWidget * _escapeButton;
        class Widget       * _escapePanel;

public:
        inline const int * getPreferredPos() const { return _preferredPos; }
        virtual void handleEvent( const class WidgetEvent *evt );
 
        GenericMenu( int w, int h, 
                     const char * name, 
                     int num_buttons,
                     const char ** button_labels,
                     const Client::State * states,
                     const char * escape_label,
                     Client::State escape_state );

        virtual ~GenericMenu();
};
#endif

