/*
 * client/SoundMenu.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "SoundMenu.h"

#include "../widgets/Widget.h"
#include "../widgets/LabelWidget.h"
#include "../widgets/ScrollpaneWidget.h"
#include "../widgets/ButtonWidget.h"
#include "../widgets/TableWidget.h"
#include "../widgets/DefaultTableModel.h"
#include "../widgets/SliderWidget.h"
#include "ClientState.h"

SoundMenu::SoundMenu( int w, int h, Client::State escape, Client::State close )
        : GenericScreen( w, h, escape, close ) 
{
        char buf[256];

        _name = "SoundMenu";

        _label = new LabelWidget( 256, 32, "Sound Settings" );
        _label->setOpaque( true );

        addCenter( _label,  h - _label->getHeight() );

        // setup mouse sensitivity stuff
        
        _sfxLabel = new LabelWidget( 192, 32, "Sound Volume" );
        _sfxLabel->setOpaque( true );

        add( _sfxLabel, 0, _label->getY() - _sfxLabel->getHeight() - 8 );
        
        _sfxSlider = new SliderWidget( w - 320, 32,
                                       SLIDER_HORIZONTAL,
                                       100,
                                       1,
                                       cl_state.sfx_vol );
        
        _sfxSlider->setOpaque( true );
        
        add( _sfxSlider, 
             _sfxLabel->getRight(), _sfxLabel->getY() );
        
        sprintf( buf, "%d", cl_state.sfx_vol );
        _sfxField = new LabelWidget( 128, 32, buf );
        _sfxField->setOpaque( true );
        
        add( _sfxField,
             _sfxSlider->getRight(), _sfxSlider->getY() );
        
        _backButton = new ButtonWidget( 128, 32, "Back" );
        _backButton->setOpaque( true );
        
        addCenter( _backButton, 16 );

        _sfxSlider->addWidgetEventListener( this );
        _backButton->addWidgetEventListener( this );
        acceptEventType( EVENT_ACTION, true );
        
}

SoundMenu::~SoundMenu() {
}

void SoundMenu::handleEvent( const class WidgetEvent * evt ) {

        char buf[128];
        
        if ( evt->getSource() == _sfxSlider ) {
                cl_state.sfx_vol = _sfxSlider->getValue();
                cl_state.sfx_mix_vol = cl_state.sfx_mix_max * cl_state.sfx_vol / 100;

                sprintf( buf, "%d", cl_state.sfx_vol );
                _sfxField->setText( buf );
        }

        else if ( evt->getSource() == _backButton ) {
                doEscapeAction();
        }
}
