/*
 * client/TownScreen.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "TownScreen.h"
#include "../widgets/ButtonWidget.h"

#include <string>
#include <cstdio>

TownScreen::TownScreen( int x, int y ) : Widget( x, y ) {
        int x_inc = x / 4;
        int y_inc = y / 3;

        _texPanels = new Widget * [ 12 ];
        
        int index = 0;
        for ( int y = 0; y < 3; ++y ) {
                for ( int x = 0; x < 4; ++x ) {
                        ++index;
                        _texPanels[ index ] = new Widget( x_inc, y_inc );
                        char name[1024];
                        sprintf( name, "icons/town-%d_%d", x, y );
                        _texPanels[ index ]->setBGTexture( name, GL_RGB );
                        add( _texPanels[ index ], x * x_inc, y * y_inc );
                }
        }
}


