/*
 * client/VideoMenu.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __VideoMenu_h__
#define __VideoMenu_h__

#include "GenericScreen.h"
#include "../widgets/WidgetEvents.h"

class VideoMenu : public GenericScreen, WidgetEventListener {
        class LabelWidget  * _label;

        class LabelWidget  * _sizeLabel;
        class SliderWidget * _sizeSlider;
        class LabelWidget  * _sizeField;
        
        class LabelWidget  * _fovLabel;
        class SliderWidget * _fovSlider;
        class LabelWidget  * _fovField;
         
        class LabelWidget   * _optionsLabel;
        class Widget        * _checkPanel;
        class LabelWidget  ** _checkLabels;
        class ButtonWidget ** _checkButtons;
        
        class ScrollpanWidget * _checkScroll;

        class ButtonWidget     * _backButton;
        
public:

        VideoMenu( int w, int h, Client::State escape, Client::State close );
        ~VideoMenu();

        void handleEvent( const class WidgetEvent * evt );
        void updateValues();
};

#endif
