/*
 * server/Projectile.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "Projectile.h"
#include "LightSource.h"
#include "Sound.h"
#include "Sprite.h"

static class Sprite _fireball_sprite( 1 );
static class Sprite _fireball_explode_sprite( 1 );
static bool _static_initialized = false;

Projectile::Projectile( Projectile::Type type = NONE, class Entity * owner = 0 ) 
        : Entity( 0, 0, 10, 10, 0 ),
          _type( type ),
          _mode( P_FLYING ),
          _counter( 0 ),
          _flight_sound( 0 ) {
        
        if ( ! _static_initialized ) {
                _static_initialized = true;
                _fireball_sprite.names[0] = strdup( "fireball" );
                _fireball_explode_sprite.names[0] = strdup( "explode" );
        }
        
        _owner = owner;

        _flight_sound = new Sound();
        
        setFlag( FLYING );
        
        switch ( _type ) {
        case FIREBALL:
                setBoundingRadius( 16 );
                setHeight( 32 );
                setLight( LightSource::getLight( 0, 0, 5, 255, 180, 0, 200, 0, -1 ) );
                _flight_sound->init( Sound::SND_FIREBALL, 50, -1, false );
                emitSound( _flight_sound );
                _sprite = &_fireball_sprite;
                break;
        default:
                break;
        }
}

Projectile::~Projectile() {
        if ( _flight_sound )
                delete _flight_sound;
}

bool Projectile::collideWith( class Entity * other, const float * normal ) {
        
        if ( other && other == _owner )
                return false;
        
        setSelfPropulsion( 0, 0, 0 );
        
        //
        // try to get a light for the explosion if needed 
        //

        if ( ! _light )
                setLight( LightSource::getLight( 0, 0, 5, 255, 180, 0, 500, -30, -1 ) );
        
        else {
                _light->_intensity = 500;
                _light->_delta = -30;
        }
        _velocity[0] = _velocity[1] = _velocity[2] = 0;
        
        _flight_sound->init( Sound::SND_EXPLOSION, 255, 0, false );
        _sprite = &_fireball_explode_sprite;
        setBoundingRadius( 64 );
        setHeight( 128 );
        moveAbsolute( 0, 0, -64 );

        _mode = P_EXPLODING;
        _counter = 0;

        return true;
}

bool Projectile::think( unsigned int tick ) {
        
        switch ( _mode ) {
        case P_FLYING:
                break;
        case P_EXPLODING:
                
                if ( getBoundingRadius() < 16 )
                        die = true;
                else {
                        setBoundingRadius( getBoundingRadius() - 1 );
                        setHeight( getHeight() - 2);
                        moveAbsolute( 0, 0, 1 );
                }
                break;
        }
        return false;
}
