/*
 * server/ProtoItem.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */


#include "ProtoItem.h"
#include <iostream>
#include <string>

ProtoItem::ProtoItem( class istream & is ) : ProtoEntity( is ) {

        ok = false;
        
        char buf[1024];
        int line_num = 0;
        
        const int NUM_LINES = 1;
        
        while ( is.getline( buf, 1024 ) ) {
                
                if ( *buf == '#' || *buf == 0 )
                        continue;

                char * token = 0;
                int token_num = 0;

                switch ( line_num ) {
                case 0:
                        
                        token = strtok( buf, " " );
                        token_num = 0;
                        
                        while ( token ) {
                                
                                switch ( token_num ) {
                                case 0: wearflag   = atoi( token ); break;
                                default: cout << " too many tokens" << endl; break;
                                }
                                ++token_num;
                                token = strtok( 0, " " );
                        }
                }

                if ( ++line_num == NUM_LINES )
                        break;
        }

        if ( line_num != NUM_LINES ) {
                // nothing to read
                if ( line_num != 0 ) {
                        cout << " error reading, got " << ( line_num - 1 ) << " lines" << endl;
                        return;
                }
        }
        
        ok = true;
}
