/*
 * server/ZoneCmd.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "ZoneCmd.h"

#include <iostream>
#include <string>
#include <cstdio>

void ZoneCmd::init() {
        ok = false;
        type = NONE;
        vnum = 0;
        pos[0] = pos[1] = pos[2] = 0;
        angle = 0;
        flags[0] = flags[1] = flags[2] = 0;
}

ZoneCmd::ZoneCmd( istream & is ) {

        init();
        
        char buf[1024];
                
        while ( is.getline( buf, 1024 ) ) {
                
                if ( *buf == '#' || *buf == 0 )
                        continue;
                
                break;
        }

        if ( *buf == 0 )
                return;
        
        type = (cmd_t) *buf;
        
        int num_tok = 0;

        int tmp_flags[3] = {0,0,0};
        int tmp_angle = 0;
        int min_tok = 0;
        
        switch ( type ) {
        case ITEM:
        case CHAR:
        case START:
                num_tok = sscanf( buf+1, "%d %d %d %d %d %d %d %d",
                                  &vnum, &pos[0], &pos[1], &pos[2], &tmp_angle,
                                  &tmp_flags[0], &tmp_flags[1], &tmp_flags[2] );
                min_tok = 5;

                break;
        case GIVE:
        case EQUIP:
                num_tok = sscanf( buf+1, "%d %d %d %d",
                                  &vnum,
                                  &tmp_flags[0], &tmp_flags[1], &tmp_flags[2] );
                
                min_tok = 2;
                
                if ( num_tok < 2 ) {
                        cout << " too few tokens " << num_tok << " for type " << (char) type << endl;
                        return;
                }
                        
                break;
        default:
                cout << " ZoneCmd unhandled token type: " << (char) type << endl;
                return;
                break;
        }
        
        if ( num_tok < min_tok ) {
                cout << " too few tokens " << num_tok << " for type " << (char) type << endl;
                return;
        }
        

        flags[0] = tmp_flags[0];
        flags[1] = tmp_flags[1];
        flags[2] = tmp_flags[2];
        
        angle = tmp_angle;
        
        ok = true;
}
