/*
 * util/TextureFont.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __TextureFont_h__
#define __TextureFont_h__

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>

#include "AbstractFont.h"

class TextureFont : public AbstractFont {

        GLuint _textureIndex;
        
public:
        static const string NAME;
        inline const string getName() const { return TextureFont::NAME; };

        inline GLuint getTextureIndex() const { return _textureIndex; }

        void startStringDraw() const;
        void endStringDraw() const;

        TextureFont( const char * const fontName ) throw ( class Exception );

        ~TextureFont();
};

#endif

