/*
 * util/vmath.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "VMath.h"

#include <iostream>

int main( int argc, char **argv ) {

        bool done = false;

        cout << " :: 0 = quit" << endl
             << " :: 1 = intersect" << endl;
        
        while ( !done ) {
                
                int type;
                cin >> type;

                switch ( type ) {
                case 0:
                        done = true;
                        break;
                        
                        // intersections
                case 1:
                        float a[2][2];
                        float b[2][2];
                        
                        cin >> a[0][0];
                        cin >> a[0][1];
                        cin >> a[1][0];
                        cin >> a[1][1];
                        cin >> b[0][0];
                        cin >> b[0][1];
                        cin >> b[1][0];
                        cin >> b[1][1];
                        
                        float u[2];
                        
                        bool res = VMath::lineSegmentsIntersect2d( a[0],
                                                                   a[1],
                                                                   b[0],
                                                                   b[1],
                                                                   &u[0],
                                                                   &u[1] );

                        cout << " :: intersect results: " << res << ", u1=" << u[0] << ", u2=" << u[1] << endl;
                }
                cout << " :: NEXT:" << endl << endl;
        }
        return 0;
}
