/*
 * widgets/ConsoleWidget.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __ConsoleWidget_h__
#define __ConsoleWidget_h__

#include "Widget.h"
#include "WidgetEvents.h"

#include <list>

class ConsoleWidget : public Widget, public WidgetEventListener {

        class TextFieldWidget * _inputField;
        class TextPaneWidget * _textPane;
        class ScrollpaneWidget * _scrollpane;
       
        list< const char * > _history;

        void pushHistory( const char * str );
        
        static const size_t MAX_HISTORY_ELEMENT_LEN = 256;
        static const size_t MAX_HISTORY_SIZE        = 64;

        int _curHistoryIndex;
        
        char _curCommandLine[ MAX_HISTORY_ELEMENT_LEN ];

public:
        void paint();
        ConsoleWidget( int w, int h );
        ~ConsoleWidget();
        void handleEvent( const class WidgetEvent *evt );
        virtual bool keyPressed( SDL_KeyboardEvent * evt, int x, int y );

};

#endif
