/*
 * widgets/DefaultTableModel.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __DefaultTableModel_h__
#define __DefaultTableModel_h__

#include "AbstractTableModel.h"

class DefaultTableModel : public virtual AbstractTableModel {
protected:
        const int _numCols;
        int _numRows;
        char ** _colNames;
        void ** _values;
        enum TableCellType * _types;

public:
        DefaultTableModel( int rows, 
                           int cols,
                           const char ** colNames,
                           const enum TableCellType * types,
                           void ** values );

        virtual inline int getColumnCount() const { 
                return _numCols;
        }
        
        virtual inline const char * getColumnName( int col ) const {
                return _colNames[ col ];
        }
        
        virtual inline const int getRowCount() const {
                return _numRows;
        }

        virtual inline const void * getValueAt( int row, int col ) const {
                if ( row >= 0 && row < _numRows &&
                     col >= 0 && col < _numCols )
                        return _values[ row * _numCols + col ];
                return 0;
        }
                
        virtual inline const enum TableCellType getColumnType( int col ) const {
                return _types[ col ];
        }
  
        virtual ~DefaultTableModel();
};
#endif

