/*
 * widgets/EventListeners.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __EventListeners_h__
#define __EventListeners_h__

#ifdef WIN32
#include <windows.h>
#endif

#include <SDL/SDL.h>

//
//
// sdl events
//
//


class KeyListener {
public:
        virtual bool keyPressed(  SDL_KeyboardEvent * evt, int x, int y ) = 0;
        virtual bool keyReleased( SDL_KeyboardEvent * evt ) = 0;
};

class MouseButtonListener {
public:
        virtual bool mousePressed(  SDL_MouseButtonEvent * evt ) = 0;
        virtual bool mouseReleased( SDL_MouseButtonEvent * evt ) = 0;
};

class MouseMotionListener {
public:
        virtual bool mouseMoved(   SDL_MouseMotionEvent * evt ) = 0;
        virtual bool mouseEntered( SDL_MouseMotionEvent * evt ) = 0;
        virtual bool mouseExited(  SDL_MouseMotionEvent * evt ) = 0;
};

#endif

