/*
 * widgets/IconGridWidget.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __IconGridWidget_h__
#define __IconGridWidget_h__

#include "Widget.h"
#include "../util/TextureManager.h"

class IconGridWidget : public Widget {
        int _rows;
        int _cols;
        class TextureObject ** _tos;
        int _numCells;
        int _cellSize[2];
public:
        IconGridWidget( int x, int y, int rows, int cols )
                : Widget( x, y ),
                  _rows( rows ),
                  _cols( cols ) {
                
                _rows = 2;
                _cols = 3;

                _numCells = rows * cols;

                _cellSize[0] = _size[0] / _cols;
                _cellSize[1] = _size[1] / _rows;

                _tos = new TextureObject * [ _numCells ];
                
                for ( int i = 0; i < _numCells; ++i ) {
                        _tos[i] = 0;
                }

                _tos[0] = TextureManager::getTexture( "gnome-joystick", GL_RGB );
                _tos[5] = TextureManager::getTexture( "gnome-logo", GL_RGB );

                if ( ! _tos[0] || !_tos[5] ) {
                        cout << "ERROR" << endl;
                        SDL_Quit();
                        exit(1);
                }

        }

        void paint() {
                glColor3f( 0.5, 0.5, 0.5 );
                glBegin( GL_LINES );
                {
                        int y = 0;
                        for ( int i = 0; i <= _rows; ++i ) {
                                glVertex2i( 0,        y );
                                glVertex2i( _size[0], y );
                                y += _size[1] / _rows;
                        }

                        int x = 0;
                        for ( int i = 0; i <= _cols; ++i ) {
                                glVertex2i( x, 0 );
                                glVertex2i( x, _size[1] );
                                x += _size[0] / _cols;
                        }

                }
                glEnd();
                
                glEnable( GL_TEXTURE_2D );

                glColor3f( 1, 1, 1 );

                for ( int i = 0; i < _numCells; ++i ) {
                        if ( _tos[i] ) {

                                glBindTexture( GL_TEXTURE_2D, _tos[i]->getIndex() );
                                
                                int corner[2] = { ( i % _cols ) * _cellSize[0],
                                                  ( i / _cols ) * _cellSize[1] };

                                glBegin( GL_QUADS );
                                {
                                        glTexCoord2f( 0, 0 );
                                        glVertex2d( corner[0],            corner[1] );
                                        glTexCoord2f( 1, 0 );
                                        glVertex2d( corner[0] + _cellSize[0],            corner[1] );
                                        glTexCoord2f( 1, 1 );
                                        glVertex2d( corner[0] + _cellSize[0],            corner[1] + _cellSize[1]);
                                        glTexCoord2f( 0, 1 );
                                        glVertex2d( corner[0],            corner[1] + _cellSize[1] );
                                }
                                glEnd();
                        }
                }
                glDisable( GL_TEXTURE_2D );
        }

        virtual class Draggable * performDNDPickup( DNDGestureEvent * evt ) {
                int cellpos[2] = { evt->x / _cellSize[0],
                                   evt->y / _cellSize[1] };
                int cellindex = cellpos[0] + cellpos[1] * _cols;

                if ( _tos[ cellindex ] == 0 )
                        return 0;

                class Draggable * d = new Draggable( "icon", _tos[ cellindex ], _tos[ cellindex ] );
                _tos[ cellindex ] = 0;
                return d;
        }
        
        virtual bool performDNDDrop(   DNDGestureEvent * evt, class Draggable ** pickup ) {
                int cellpos[2] = { evt->x / _cellSize[0],
                                   evt->y / _cellSize[1] };
                int cellindex = cellpos[0] + cellpos[1] * _cols;
                
                if ( _tos[ cellindex ] != 0 ) {
                        *pickup = new Draggable( "icon", _tos[ cellindex ], _tos[ cellindex ] );
                }
                
                _tos[ cellindex ] = (class TextureObject *) evt->draggable->getObject();
                
                delete evt->draggable;
                evt->draggable = 0;
                return true;
        }
        

};

#endif
