/*
 * widgets/TabbedpaneWidget.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __TabbedPaneWidget_h__
#define __TabbedPaneWidget_h__

#include "Widget.h"
#include "ButtonWidget.h"
#include "WidgetEvents.h"

enum TabType {
        TAB_TOP,
        TAB_BOTTOM,
        TAB_LEFT,
        TAB_RIGHT
};


class TabbedpaneWidget : public Widget {
        friend class TabListener;
        friend class TabButton;

        enum TabType          _tabType;
        int                   _numWidgets;
        int                   _curIndex;
        char               ** _widgetNames;
        class TabButton    ** _tabButtons;
        class Widget       ** _widgets;
        int                   _paneDisplayRect[2][2];
        int                   _fontMargin;
        class TabListener * _tabListener;
        
public:
        TabbedpaneWidget( int w,
                          int h, 
                          enum TabType type,
                          int num_widgets, 
                          char **  widget_names, 
                          class Widget ** widgets );
        
        void display();
        void paint();

        void setSelectedIndex( int index );
};


class TabListener : public WidgetEventListener {
        class TabbedpaneWidget *_pane;
        friend class TabbedpaneWidget;

        TabListener( class TabbedpaneWidget * wid ) {
                _pane = wid;
        }
public:
        void handleEvent( const class WidgetEvent *evt );
};

/**
 * a TabButton is NOT SELECTED when its tab is active
 * a SELECTED tab is in the background.
 * this is counter-intuitive but easiest to implement using existing ButtonWidget code
 */

class TabButton : public ButtonWidget {
        friend class TabbedpaneWidget;

        const class TabbedpaneWidget * _pane;

        TabButton( const int width, const int height, 
                   const class TabbedpaneWidget * pane, 
                   const char *message = 0 );
public:
        void paint();
};

#endif


