/*
 * widgets/Viewport.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Viewport_h__
#define __Viewport_h__

#include "Widget.h"

/**
 * A viewport or 'porthole' onto a sub-widget.  used by scrollpanes
 */
class Viewport : public Widget {

        class Widget * _view;

        int _viewPosition[2];

public:
        Viewport( int w, int h, class Widget * view );
        ~Viewport();

        virtual void display();
        
        class Widget * getView() const { return _view; }
        void setView( class Viewport * v ) { _view = v; }
        const int * getViewPosition() const { return _viewPosition; }
        
        void setViewPosition( enum ScrollType type, int amount );
        void scrollUnits( enum ScrollType type, int amount );
        void scrollBlocks( enum ScrollType type, int amount );

        /**
         * returns the new  position of the viewport along the specified axis
         */
        int scrollPixels( enum ScrollType type, int amount );
        
        virtual void paint();
};

              
#endif
