/*
 * DG.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __DG_h__
#define __DG_h__

#include <SDL/SDL.h>

#ifdef WIN32

#include <windows.h>
#endif

#include <GL/gl.h>

/**
 */

class DG {
        int MAX_FPS;
        /**
         * minimum time for a frame, in ms
         */
        int MIN_FRAMETIME;
        class Graphics * _graphics;
        
        bool _hasInputFocus;
        bool _showFPS;

        bool _escape_down;

        bool _film_session;

        bool _run;

public:
        void end() { _run = false; }
        
        int handleEvent( SDL_Event *event );
        int startGameLoop( int argc, char **argv );
        inline void setMaxFPS( int max ) { MAX_FPS = max; MIN_FRAMETIME = 1000/max;}
        DG( int argc, char **argv ) throw (class Exception);
        ~DG();

        inline bool hasInputFocus() { return _hasInputFocus; }

        bool isFilmSession() const { return _film_session; }
        void setFilmSession( bool val ) { _film_session = val; }

};

#endif
