/*
 * client/ClientSprite.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>
#include "ClientSprite.h"

#include "../util/TextureManager.h"
#include "../server/Sprite.h"

ClientSprite::ClientSprite( const class Sprite * sprite ) {
        texs = new TextureObject * [ sprite->num_frames ];
        
        for ( int i = 0; i < sprite->num_frames; ++i ) {
                texs[i] = TextureManager::getTexture( sprite->names[i], GL_RGBA );
        }
}


ClientSprite::~ClientSprite() {
        delete[] texs;
        texs = 0;
}
