/*
 * server/Camera.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "Camera.h"
#include <string>

Camera::Camera( Type aType, float x, float y, float z, int aZoom ) {
        type = aType;
        msg = 0;
        zoom = aZoom;
        angles[0] = x;
        angles[1] = y;
        angles[2] = z;
}

Camera::~Camera() {
        if ( msg ) 
                free( msg );
}

void Camera::setMessage( const char * aMsg, unsigned int timeout ) {
        if ( msg )
                free( msg );

        if ( aMsg )
                msg = strdup( aMsg );
        else
                msg = 0;

        msg_timeout = timeout;
}
