/*
 * server/Camera.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Camera_h__
#define __Camera_h__

struct Camera {
        enum Type {
                FIRST_PERSON,
                THIRD_PERSON_FOLLOW,
                THIRD_PERSON
        };

        Type type;

        float angles[3];
        int zoom;
        char * msg;
        unsigned int msg_timeout;

        Camera( Type aType, float x, float y, float z, int zoom );
        ~Camera();

        void setMessage( const char * aMsg, unsigned int timeout );
};

#endif
