/*
 * server/Lightmap.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Lightmap_h__
#define __Lightmap_h__

class Lightmap {
public:
        static const int TEX_RES = 16;

        bool modified;
        bool needs_rebind;

        short size[2];
        short use_size[2];
        
        unsigned char *static_pixels;
        unsigned char *rgb_pixels;

        class ClientLightmap * clientLightmap;
        void setSize( int x, int y );

        Lightmap();
        ~Lightmap();
        
        void load( class istream & is );
        void writeLightmap( class ostream & os );
        
        void clampEdges( unsigned char * pix );
        
        void clear( unsigned char r, unsigned char g, unsigned char b );

        friend class ostream & operator<<( class ostream & os, const Lightmap & lm );
};

#endif
