/*
 * server/Player_net.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "Player.h"
#include "Peer.h"

#include <iostream>

bool Player::send( const char * msg ) {
        if ( _peer == 0 )
                return false;
        
        char sucks[ 1024 ];
        strncpy( sucks, msg, 1024 );
        sucks[ 1023 ] = 0;

        SDLNet_TCP_Send( _peer->sock, sucks, strlen( sucks ) );
        return true;
}


void Player::interpret( const char * buf ) {
        char cmdname[1024];

        cout << " interpret: " << buf << endl;
        
        if ( sscanf( buf, "%s", cmdname ) == 1 ) {
                cout << " cmdname: " << cmdname << ", buf: " << buf;
                
                buf += strlen( cmdname );
                
                if ( ! strcmp( cmdname, "equip" ) ) {
                        int inv_index = 0;
                        int eq_index  = 0;
                        
                        int ret = sscanf( buf, " %d %d", &inv_index, &eq_index );

                        if ( ret != 2 )
                                cout << "error" << endl;
                        
                        
                        class Item * item = (Item*) removeContentAt( inv_index );
                        
                        if ( item ) {
                                
                                if ( equipItem( item, (WornPosition) eq_index ) )
                                        send( buf );
                                else
                                        send( "unable to equip" );
                        }
                        else
                                send( "unable to remove" );
                }
        }
}

void Player::handleInput( const char * data, int len ) {
        
        cout << " handleInput: " << data << endl;
        const char *ptr = data;
        const char *endPtr = ptr + 1;
        const char *finalPtr = data + len;

        while ( endPtr <= finalPtr ) {
                if ( *endPtr == 0 ) {
                        interpret( ptr );
                        ++endPtr;
                        ptr = endPtr;
                        continue;
                }
                ++endPtr;
        }
        
        /*
        PlayerCommandType cmdType = (PlayerCommandType) *data;
        
        const char * endPtr = data + len;
        
        const char * ptr = data + 1;
        
        if ( ptr >= endPtr )
                return;
        
        while ( ptr < endPtr ) {
                switch ( cmdType ) {
                case CMD_EQUIP_ITEM: {
                        int inv_index = *( (Uint8 *) ptr );
                        if ( ++ptr >= endPtr )
                                return;
                        int eq_index = *( (Uint8 *) ptr );
                        ++ptr;
                        
                        class Item * item = (Item*) removeContentAt( inv_index );

                        if ( item ) {
                                equipItem( item, (WornPosition) eq_index );
                        }
                        break;
                }
                default:
                        cout << " cannot handle command type " << (int) cmdType << endl;
                        break;
                }
        }
        */
}
